package pt.caf_pbs.schooldiskclient.model;


import pt.caf_pbs.schooldiskclient.exceptions.InvalidDataException;

public class Subject {

    private String initials;
    private String designation;

    public Subject() {
    }

    public Subject(String initials, String designation) {
        setInitials(initials);
        this.designation = designation;
    }

    private boolean isInitialsValid(String initials) {
        if (initials.length() < 4) {
            return false;
        }
        return true;
    }

    public String getInitials() {
        return initials;
    }

    public void setInitials(String initials) {
        if (isInitialsValid(initials)) {
            this.initials = initials;
        } else {

            String msg = "Instructor: " + initials;
            throw new InvalidDataException(msg);
        }
    }

    public String getDesignation() {
        return designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

}
